/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class TMacSpecModifyWizard
implements JDMWizardPanelDelegate {
    protected static ResourceBundle bundle = ResourceBundle.getBundle("ibm.nways.jdm8260.Resources");
    protected JdmBrowser browser;
    protected int connMode;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        String string = "setDefaults";
        DestinationPropBook destinationPropBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        this.browser = (JdmBrowser)destinationPropBook.getBrowser();
        Hashtable hashtable = jDMWizardInfo.getItems();
        GenModel genModel = jDMWizardInfo.getModel();
        try {
            ModelInfo modelInfo = genModel.getInfo("Spec");
            if (hashtable != null) {
                this.connMode = (Integer)modelInfo.get("Spec.TMACModInterfaceMode");
                hashtable.put("tMACModInterfaceMode", modelInfo.get("Spec.TMACModInterfaceMode"));
                hashtable.put("tMACModTRMacAddrType", modelInfo.get("Spec.TMACModTRMacAddrType"));
                hashtable.put("tMACModTRLocAdminAddr", modelInfo.get("Spec.TMACModTRLocAdminAddr"));
                hashtable.put("tMACModTREarlyTokenRel", modelInfo.get("Spec.TMACModTREarlyTokenRel"));
                hashtable.put("tMACModTRMonitorConten", modelInfo.get("Spec.TMACModTRMonitorConten"));
                hashtable.put("tMACModTRInternalWrap", modelInfo.get("Spec.TMACModTRInternalWrap"));
                hashtable.put("tMACModTRExternalWrap", modelInfo.get("Spec.TMACModTRExternalWrap"));
                hashtable.put("tMACModRMONStatsMode", modelInfo.get("Spec.TMACModRMONStatsMode"));
                hashtable.put("tMACModDot5StatsMode", modelInfo.get("Spec.TMACModDot5StatsMode"));
                hashtable.put("tMACModRMONHostStatsMode", modelInfo.get("Spec.TMACModRMONHostStatsMode"));
                hashtable.put("tMACModRMONRingStationStatsMode", modelInfo.get("Spec.TMACModRMONRingStationStatsMode"));
                hashtable.put("tMACModRMONMLStatsMode", modelInfo.get("Spec.TMACModRMONMLStatsMode"));
                hashtable.put("tMACModRMONPStatsMode", modelInfo.get("Spec.TMACModRMONPStatsMode"));
                hashtable.put("tMACModRMONSrcRoutingStatsMode", modelInfo.get("Spec.TMACModRMONSrcRoutingStatsMode"));
                hashtable.put("tMACModRMONSurrogateStatsMode", modelInfo.get("Spec.TMACModRMONSurrogateStatsMode"));
                hashtable.put("tMACModARPResolveMethod", modelInfo.get("Spec.TMACModARPResolveMethod"));
                hashtable.put("readytogo", "yes");
                this.displayMsg("TMac_modifyConfirm");
                return;
            }
            this.displayMsg("TMac_modifyNoConfirm");
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string, exception);
            return;
        }
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        this.displayMsg("TMac_modifyAbort");
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        String string = "proceed";
        boolean bl = true;
        GenModel genModel = jDMWizardInfo.getModel();
        Hashtable hashtable = jDMWizardInfo.getItems();
        if (hashtable.get("readytogo").equals("yes")) {
            ModelInfo modelInfo = new ModelInfo();
            modelInfo.add("Spec.TMACModInterfaceMode", (Integer)hashtable.get("tMACModInterfaceMode"));
            if (this.connMode != 1) {
                modelInfo.add("Spec.TMACModTRMacAddrType", (Integer)hashtable.get("tMACModTRMacAddrType"));
                modelInfo.add("Spec.TMACModTRLocAdminAddr", (OctetString)hashtable.get("tMACModTRLocAdminAddr"));
            }
            modelInfo.add("Spec.TMACModTREarlyTokenRel", (Integer)hashtable.get("tMACModTREarlyTokenRel"));
            modelInfo.add("Spec.TMACModTRMonitorConten", (Integer)hashtable.get("tMACModTRMonitorConten"));
            modelInfo.add("Spec.TMACModTRInternalWrap", (Integer)hashtable.get("tMACModTRInternalWrap"));
            modelInfo.add("Spec.TMACModTRExternalWrap", (Integer)hashtable.get("tMACModTRExternalWrap"));
            modelInfo.add("Spec.TMACModRMONStatsMode", (Integer)hashtable.get("tMACModRMONStatsMode"));
            modelInfo.add("Spec.TMACModDot5StatsMode", (Integer)hashtable.get("tMACModDot5StatsMode"));
            modelInfo.add("Spec.TMACModRMONHostStatsMode", (Integer)hashtable.get("tMACModRMONHostStatsMode"));
            modelInfo.add("Spec.TMACModRMONRingStationStatsMode", (Integer)hashtable.get("tMACModRMONRingStationStatsMode"));
            modelInfo.add("Spec.TMACModRMONMLStatsMode", (Integer)hashtable.get("tMACModRMONMLStatsMode"));
            modelInfo.add("Spec.TMACModRMONPStatsMode", (Integer)hashtable.get("tMACModRMONPStatsMode"));
            modelInfo.add("Spec.TMACModRMONSrcRoutingStatsMode", (Integer)hashtable.get("tMACModRMONSrcRoutingStatsMode"));
            modelInfo.add("Spec.TMACModRMONSurrogateStatsMode", (Integer)hashtable.get("tMACModRMONSurrogateStatsMode"));
            modelInfo.add("Spec.TMACModARPResolveMethod", (Integer)hashtable.get("tMACModARPResolveMethod"));
            try {
                modelInfo = genModel.setInfo("Spec", modelInfo);
                bl = this.checkSetInfo(modelInfo);
            }
            catch (Exception exception) {
                RAS.logException(19, 2, this, string, exception);
                bl = false;
            }
        }
        if (bl) {
            this.displayMsg("TMac_modifyOK");
        } else {
            this.displayMsg("TMac_modifyError");
        }
        return bl;
    }

    private boolean checkSetInfo(ModelInfo modelInfo) {
        String string = "checkSetInfo";
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string2);
            if (!(serializable instanceof SpecialValue)) continue;
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Got a special value for ID -> " + string2);
            }
            return false;
        }
        return true;
    }

    protected void displayMsg(String string) {
        if (this.browser != null) {
            this.browser.displayMsg(TMacSpecModifyWizard.getNLSString(string));
        }
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = bundle.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }
}

